package gov.va.vinci.dart.json;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class PILocationView implements Comparable {

	@NotNull
	@Size(min=2,max=512)
	private String location;	//location name
	
	@Min(1)
	private int locationId;	//location ID (starts at 1)
	
	private boolean primary;
	
	@NotNull
	@Size(min=2,max=512)
	private String primaryInvestigator;
	
	@NotNull
	@Size(min=2,max=512)
	private String primaryInvestigatorUserId;
	
	public PILocationView() {}

	public PILocationView(final String location, final int locationId, final boolean primary, final String primaryInvestigator, final String primaryInvestigatorUserId) {
		this.location = location;
		this.locationId = locationId;
		this.primary = primary;
		this.primaryInvestigator = primaryInvestigator;
		this.primaryInvestigatorUserId = primaryInvestigatorUserId;
	}

	public String getLocation() {
		return location;
	}
	
	public void setLocation(String location) {
		this.location = location;
	}
	
	public boolean isPrimary() {
		return primary;
	}
	
	public void setPrimary(boolean primary) {
		this.primary = primary;
	}
	
	public String getPrimaryInvestigator() {
		return primaryInvestigator;
	}
	
	public void setPrimaryInvestigator(String primaryInvestigator) {
		this.primaryInvestigator = primaryInvestigator;
	}

	public String getPrimaryInvestigatorUserId() {
		return primaryInvestigatorUserId;
	}

	public void setPrimaryInvestigatorUserId(String primaryInvestigatorUserId) {
		this.primaryInvestigatorUserId = primaryInvestigatorUserId;
	}
	
	public int getLocationId() {
		return locationId;
	}

	public void setLocationId(int locationId) {
		this.locationId = locationId;
	}
	
	
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (PILocationView.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		PILocationView loc2 = (PILocationView)o;

		
//TODO: just sort by locationId and ignore the primary location value? (always display in the same order)
//		//primary location first
//		if( isPrimary() )
//			return -1;
//		else if( loc2.isPrimary() )
//			return 1;


//TODO: currently sorting by locationId instead of location name
//		//sort by location name
//		if (getLocation() == null) {
//			return loc2.getLocation() == null ? 0 : -1;
//		}
//
//		return getLocation().compareTo(loc2.getLocation());
		
		
		//sort by location ID
		if( getLocationId() < loc2.getLocationId() )
			return -1;
		
		if( getLocationId() == loc2.getLocationId() )
			return 0;
		
		return 1;
	}	
}
